type
  TGradientTabSet=class(TCustomControl)
  private
   FTabList            :TStringList;
   FTabIndex           :Integer;
   FLeftOffset         :Integer;
   FImages             :TCustomImageList;
   FImageChangeLink    :TChangeLink;
   FOnChange           :TNotifyEvent;
   FOnTabChanging      :TTabChangingEvent;
   FOnGetImageIndex    :TTabGetImageEvent;
   FOnGetOverlayImageIndex:TTabGetImageEvent;
   FOnGetHint          :TTabGetHintEvent;
   FMemBitmap          :TBitmap;
   FTabPositions       :TObjectList;
   FDrawer             :TGradientTabDrawer;
   FScroller           :TTabScroller;
   FTabPositionsValid  :Boolean;
   FUseSystemColors    :Boolean;
  public
   constructor Create(AOwner: TComponent);
   class destructor Destroy;
   function ItemAtPos(const Pos: TPoint): Integer;
   function ItemAtPos(const X: Integer; const Y: Integer): Integer;
   function ItemRect(const Index: Integer): TRect;
   procedure SelectNext(GoForward: Boolean);
   function GetFirstShownIndex: Integer;
   function GetLastShownIndex: Integer;
   procedure BeginUpdate;
   procedure EndUpdate;
   property Color: TColor;
   property Drawer: TGradientTabDrawer;
   property UseSystemColors: Boolean;
   property MouseCapture: Boolean;
  published
   property Align: TAlign;
   property Anchors: TAnchors;
   property Constraints: TSizeConstraints;
   property DragCursor: TCursor;
   property DragKind: TDragKind;
   property DragMode: TDragMode;
   property Enabled: Boolean;
   property Font: TFont;
   property Images: TCustomImageList;
   property ParentBackground: Boolean;
   property ParentShowHint: Boolean;
   property PopupMenu: TPopupMenu;
   property Scroller: TTabScroller;
   property ShowHint: Boolean;
   property Items: TStrings;
   property TabColors: TTabColors;
   property TabIndex: Integer;
   property Visible: Boolean;
   property OnAlignInsertBefore: TAlignInsertBeforeEvent;
   property OnAlignPosition: TAlignPositionEvent;
   property OnClick: TNotifyEvent;
   property OnDblClick: TNotifyEvent;
   property OnChange: TNotifyEvent;
   property OnChanging: TTabChangingEvent;
   property OnGetHint: TTabGetHintEvent;
   property OnDragDrop: TDragDropEvent;
   property OnDragOver: TDragOverEvent;
   property OnEndDock: TEndDragEvent;
   property OnEndDrag: TEndDragEvent;
   property OnEnter: TNotifyEvent;
   property OnExit: TNotifyEvent;
   property OnGetImageIndex: TTabGetImageEvent;
   property OnGetOverlayImageIndex: TTabGetImageEvent;
   property OnMouseActivate: TMouseActivateEvent;
   property OnMouseDown: TMouseEvent;
   property OnMouseMove: TMouseMoveEvent;
   property OnMouseUp: TMouseEvent;
   property OnStartDock: TStartDockEvent;
   property OnStartDrag: TStartDragEvent;
   property FirstShownIndex: Integer;
   property LastShownIndex: Integer;
  end;
